//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Link.h"
#pragma package(smart_init)

#include <shellapi.h>
//---------------------------------------------------------------------------
static inline TLink *ValidCtrCheck()
{
	return new TLink(NULL);
}
//---------------------------------------------------------------------------
__fastcall TLink_base::TLink_base(TComponent* Owner)
	: TCustomLabel(Owner) //mod
{
//Set<TFontStyle, fsBold, fsStrikeOut>  LinkStyle;
TFontStyles LinkStyle;
LinkStyle << fsUnderline;
Font->Color=clNavy;
Font->Style=LinkStyle;
OnClick=&Connect;
OnMouseDown=&ChangeColorActive; //mod
OnMouseUp=&ChangeColorInactive; //mod
Screen->Cursors[crLink] = LoadCursor(HInstance,"LINK");
Cursor=crLink;

//mod
ShowAccelChar=false;
WordWrap=false;
FInactiveColor=clNavy;
FActiveColor=clBlack;
}

void __fastcall TLink_base::Connect(TObject* Sender)
	{ShellExecute(NULL,"open",Address.c_str(),"","",SW_NORMAL);}

//mod
void __fastcall TLink_base::ChangeColorActive(TObject* Sender,TMouseButton Button,Classes::TShiftState Shift,int X,int Y)
	{Font->Color=FActiveColor;}

void __fastcall TLink_base::ChangeColorInactive(TObject* Sender,TMouseButton Button,Classes::TShiftState Shift,int X,int Y)
	{Font->Color=FInactiveColor;}

void __fastcall TLink_base::SetColor(TColor AColor)
	{
    FInactiveColor=AColor;
    Font->Color=FInactiveColor;
    }

void __fastcall TLink_base::SetDescription(System::AnsiString ADescription)
	{
    FDescription=ADescription;
    Caption=FDescription;
    }

//---------------------------------------------------------------------------

__fastcall TLink::TLink(TComponent* Owner)
	: TLink_base(Owner)
{
Description="http://www.phys.uni.torun.pl/~jacek"; //mod
FAddress=Description;
Hint="Link to "+Address;
ShowHint=true;
}

void __fastcall TLink::CheckAddress(System::AnsiString _URL)
	{
    if (_URL.SubString(1,7)!="http://") _URL="http://"+_URL;
    FAddress=_URL;
    }

//---------------------------------------------------------------------------
__fastcall TMail::TMail(TComponent* Owner)
	: TLink_base(Owner)
{
Description="jacek@phys.uni.torun.pl"; //mod
FAddress="mailto:"+Description;
Hint="Send a message to "+Description;
ShowHint=true;
}


void __fastcall TMail::CheckAddress(System::AnsiString _Address)
	{
    if (_Address.SubString(1,7)!="mailto:") {_Address="mailto:"+_Address; FAddress=_Address;}

    int hash=0;
    for(int i=0;i<_Address.Length();i++)
    	if ((_Address.c_str())[i]=='@') hash=i;
    if (hash==0) {ShowMessage("E-mail adress should include '@'.");} else {FAddress=_Address;};
    }
//---------------------------------------------------------------------------
namespace Link
{
	void __fastcall PACKAGE Register()
	{
        TComponentClass classes[2] = {__classid(TLink), __classid(TMail)};
		RegisterComponents("JM", classes, 1);
	}
}
//---------------------------------------------------------------------------
